<?php
/**
 * Plugin Name: شتاب وردپرس - Bad Domain Blocker
 * Description: با کمک این افزونه می‌توانید دامنه‌هایی مثل YITH و دامنه‌های مشابه که فیلتر یا تحریم شده‌اند را مسدود کنید تا ریکوئست‌های آن‌ها باعث کندی پیشخوان وردپرس نشوند.
 * Version: 1.0
 * Author: شتاب وردپرس
 * Author URI: https://shetabwp.com/
 * Plugin URI: https://shetabwp.com/bad-domain-blocker/
*/

if (!defined('ABSPATH')) exit;

define('BBD_OPTION_KEY', 'shwp-bad-domain-blocker');

// بلاک کردن درخواست‌ها
add_filter('pre_http_request', function ($pre, $args, $url) {
    $blocked_domains = get_option(BBD_OPTION_KEY, []);
    foreach ($blocked_domains as $domain) {
        if (strpos($url, $domain) !== false) {
            return new WP_Error('blocked_domain', 'shetabwp.com - This domain is blocked.');
        }
    }
    return false;
}, 99, 3);

// منوی تنظیمات
add_action('admin_menu', function () {
    add_menu_page(
        'بلوک کننده دامنه',
        'بلوک کننده دامنه',
        'manage_options',
        'shwp-bad-domain-blocker',
        'bbd_admin_page',
        'dashicons-shield-alt',
        80
    );
});

add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'bbd_add_settings_link');

function bbd_add_settings_link($links) {
    $settings_url = admin_url('admin.php?page=shwp-bad-domain-blocker');
    $custom_link = '<a href="' . esc_url($settings_url) . '">افزودن دامنه بد</a>';
    array_push($links, $custom_link); // نمایش در ابتدای لیست
    return $links;
}


// صفحه تنظیمات
function bbd_admin_page() {
    $blocked_domains = get_option(BBD_OPTION_KEY, []);
    ?>
    <div class="wrap">
        <h1 style="margin-bottom: 30px;">مدیریت دامنه‌های بلوک شده</h1>
        
        <form id="bbd-form">
            <input type="text" id="bbd_new_domain" class="regular-text" placeholder="مثلاً blocked.com">
            <button type="submit" class="button button-primary">افزودن دامنه</button>
            <span id="bbd-message"></span>
        </form>

        <h2 style="margin-top: 30px;">لیست دامنه‌های مسدود شده</h2>
        <table class="widefat striped" id="bbd-table">
            <thead>
                <tr>
                    <th>دامنه</th>
                    <th>عملیات</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($blocked_domains)): ?>
                    <tr>
                        <td colspan="2" style="text-align: center; color: #888;">هیچ دامنه‌ای اضافه نشده است.</td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($blocked_domains as $domain): ?>
                        <tr>
                            <td><?= esc_html($domain) ?></td>
                            <td><button class="button bbd-delete" data-domain="<?= esc_attr($domain) ?>">حذف</button></td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>

        </table>
        
        <div style="margin: 30px 0">
            <p>برای یافتن ریکوئست‌های کُند، افزونه Query Monitor رو نصب کنید و بعد از رفرش صفحه از ابزار بالای صفحه، بخش HTTP API Calls ریکوئست‌هایی که تایم زیادی دارند یا به رنگ قرمز نمایش داده شدند رو پیدا کرده و دامنه آنها را به لیست اضافه کنید. </br>با اینکار ارسال ریکوئست به دامنه فوق مسدود می‌شود و سرعت پیشخوان افزایش می‌یابد.</p>
            <p>جهت نصب افزونه کوئری مانیتور کلیک کنید » <a href="<?php echo admin_url( 'plugin-install.php?s=query%2520monitor&amp;tab=search&amp;type=term' ) ?>" target="_blank" rel="noopener">نصب افزونه Query Monitor</a></p>
            <p>جهت آموزش کار با افزونه کلیک کنید »  <a href="https://shetabwp.com/bad-domain-blocker/" target="_blank" rel="noopener">آموزش تصویری نحوه کار</a></p>
        </div>
        
    </div>

    <style>
        #bbd-form {
            margin-bottom: 20px;
        }
        #bbd-message {
            margin-right: 15px;
            font-weight: bold;
            color: green;
        }
    </style>

    <script>
        jQuery(document).ready(function ($) {
            $('#bbd-form').on('submit', function (e) {
                e.preventDefault();
                const domain = $('#bbd_new_domain').val();
                $('#bbd-message').css('color', 'green').text('در حال افزودن...');

                $.post(ajaxurl, {
                    action: 'bbd_add_domain',
                    nonce: '<?= wp_create_nonce('bbd_nonce') ?>',
                    domain: domain
                }, function (response) {
                    if (response.success) {
                        $('#bbd-message').css('color', 'green').text(response.data);
                        $('#bbd_new_domain').val('');
                        $('#bbd-table tbody tr:contains("هیچ دامنه‌ای اضافه نشده است.")').remove();
                        $('#bbd-table tbody').append(`<tr><td>${domain}</td><td><button class="button bbd-delete" data-domain="${domain}">حذف</button></td></tr>`);
                    } else {
                        $('#bbd-message').css('color', 'red').text(response.data);
                    }
                });
            });

            $('#bbd-table').on('click', '.bbd-delete', function () {
                const row = $(this).closest('tr');
                const domain = $(this).data('domain');

                if (!confirm(`آیا از حذف ${domain} مطمئن هستید؟`)) return;

                $.post(ajaxurl, {
                    action: 'bbd_delete_domain',
                    nonce: '<?= wp_create_nonce('bbd_nonce') ?>',
                    domain: domain
                }, function (response) {
                    if (response.success) {
                        row.remove();
                        
                        // اگر جدول خالی شد، پیام "هیچ دامنه‌ای اضافه نشده است." رو نمایش بده
                        if ($('#bbd-table tbody tr').length === 0) {
                            $('#bbd-table tbody').append(`
                                <tr>
                                    <td colspan="2" style="text-align: center; color: #888;">هیچ دامنه‌ای اضافه نشده است.</td>
                                </tr>
                            `);
                        }
                        
                    }
                });
            });
        });
    </script>
    <?php
}

// AJAX: افزودن دامنه
add_action('wp_ajax_bbd_add_domain', function () {
    check_ajax_referer('bbd_nonce', 'nonce');
    $domain = trim(sanitize_text_field($_POST['domain'] ?? ''));
    if (!$domain) {
        wp_send_json_error('دامنه معتبر نیست.');
    }

    $blocked_domains = get_option(BBD_OPTION_KEY, []);
    if (in_array($domain, $blocked_domains)) {
        wp_send_json_error('این دامنه قبلاً ثبت شده است.');
    }

    $blocked_domains[] = $domain;
    update_option(BBD_OPTION_KEY, $blocked_domains);
    wp_send_json_success('دامنه اضافه شد.');
});

// AJAX: حذف دامنه
add_action('wp_ajax_bbd_delete_domain', function () {
    check_ajax_referer('bbd_nonce', 'nonce');
    $domain = trim(sanitize_text_field($_POST['domain'] ?? ''));
    $blocked_domains = get_option(BBD_OPTION_KEY, []);
    $blocked_domains = array_filter($blocked_domains, function($d) use ($domain) {
        return $d !== $domain;
    });

    update_option(BBD_OPTION_KEY, $blocked_domains);
    wp_send_json_success('دامنه حذف شد.');
});
